	NAME	UPDATE
	INCLUDE	PAGESIZE.INC
	TITLE	.UPDATE - Background Line update routine
;
; UPDATE - strategy routine used to determine which lines to update 
; on the display screen.  For speed and perceived response the line
; the cursor is on and the STATUS line are updated more frequently
; than the rest of the display.  A secondary routine is actually 
; called to update the chosen line from either the on-board IRMA 
; interface buffer or from a saved screen in a memory buffer.
;
; On entry: Nothing useful
;
; On exit: Nothing useful
; 
; Called by: E78I
;
; Routines called: UPDLIN  
;
; Globals changed: OLDLIN, BGCNT0, BGCNT1, BGCNT2, BGLIN, PRVATR
;		   ATRSAV, NOATRS, TOPSET
;
; Globals accessed: AUXST, STATUS, DISLIN
;
; History:
;   Date    Version   Prog.   Comments
; 1/22/85    1.40      jsc	Added changes for IRMAvision
;
DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU
	EXTRN	BGCNT0:BYTE,	BGCNT1:BYTE,	BGCNT2:BYTE
	EXTRN	BGCNT3:BYTE,	BGLIN:BYTE,	CURLIN:BYTE
	EXTRN	FKEY10:BYTE,	COLROW:WORD,	NBUF:BYTE
	EXTRN	NOATRS:BYTE,	PRVATR:BYTE,	ATRSAV:BYTE
	EXTRN	STATUS:BYTE,	AUXST:BYTE,	OLDLIN:BYTE
	EXTRN	CHARST:BYTE,	TOPLIN:WORD,	BSADDR:WORD
	EXTRN	TOPSET:BYTE,	SLVERR:BYTE,	SCRNMOD:BYTE
	EXTRN	DISLIN:BYTE,	ENADIS:BYTE
DATA	ENDS

CODE	SEGMENT PUBLIC BYTE	; Normal program segment
	ASSUME	CS:CODE
	EXTRN	UPDLIN:NEAR,	PUTCH:NEAR,	ATCALC:NEAR
	EXTRN	READCH:NEAR,	SCRNFX:NEAR

	PUBLIC	UPDATE		; General update process entry
UPDATE	PROC	NEAR
	TEST	AUXST,M$CINH	; Is this a good cursor?
	JNZ	UPD0		; No, do not update my numbers

	MOV	AL,CURLIN	; Update the local line number
	MOV	OLDLIN,AL	;

	MOV	BGCNT2,0	; Reset attribute scan occured flag

UPD0:	TEST	STATUS,M$DIRT	; Test for buffer dirty since
	JZ	UPD10		;      last pass

UPD01:	MOV	TOPSET,4	; Re-align the screen soon [1.48]


	MOV	BGLIN,0		; Reset the screen wipe controls
	MOV	AL,DISLIN	; Get # of lines on display screen
	MOV	BGCNT0,AL	; Make it # of lines to be painted
	MOV	NOATRS,0	; Clear attribute scan not needed flag

UPD2:	TEST	BGCNT1,11B	; Is this an odd or even pass?
	MOV	BL,0		; Force stat line update, but check...
	JZ	UPD2A		; Odd pass - update the status line

	MOV	BL,OLDLIN	; Even pass, update wherever we are
UPD2A:	CALL	UPDLIN		;

UPD3:	INC	BGCNT1		; Toggle the pass flag

UPD4:	JMP	SHORT UPDXT	; All done!

UPD10:	CMP	BGCNT0,0	; Are we out of lines to wipe?
	JE	UPDXT		; Yes, use a short exit path

	MOV	BL,BGLIN	; Get the current wipe line
	CMP	BL,0		; Is this the first line?
	JNZ	UPD10A		;

	MOV	BL,OLDLIN	; Do current line first to speed echo
	CALL	UPDLIN		;

	MOV	BL,0		; And then do the status line!

UPD10A:	CALL	UPDLIN		; And paint it

	INC	BGLIN		; Next background please
	DEC	BGCNT0		; One less line to do
	JNZ	UPDXT		; Not done, use a short exit

	CMP	NOATRS,0	; Is the attribute count zero?
	JNE	UPDXT		; No, all is well

	CMP	BGCNT2,0	; Have we done no scans before?
	JNE	UPDXT		; already done this, quit shortly

	MOV	BGCNT2,1	; Remember we have done a cleanup

	MOV	BGCNT1,1	; Set up to do the current line

	MOV	CX,45		; Attribute chain location count
	XOR	BX,BX		; An offset into array

	MOV	AL,PRVATR	; The default screen attribute
	MOV	AH,ATRSAV	; The default IBM style attribute

UPD11:	MOV	PRVATR[BX],AL	; Reset the attribute pass chain
	MOV	ATRSAV[BX],AH	;
	INC	BX		; Next entry	
	LOOP	UPD11		; Until entire chain full of defaults
	JMP	UPD01		; And force a new wipe [1.48]

UPDXT:	RET			; End of update process

UPDATE	ENDP
	PAGE
;
; UPDRST - procedure to reset the UPDATE procedures control words.
;
; On entry: Nothing useful
;
; On exit: Nothing useful
; 
; Called by: ?
;
; Routines called: READCH, ATCALC
;
; Globals changed: BGCNT0, BGLIN, PRVATR, ATRSAV, CHARST
;
; Globals accessed: TOPLIN, SCRNMOD, DISLIN
;
; History:
;   Date    Version   Prog.   Comments
; 1/22/85    1.40      jsc	Added changes for IRMAvision
;
	PUBLIC	UPDRST
UPDRST	PROC	NEAR		; Reset UPDATE control words
	PUSH	SI		; Save the registers first
	PUSH	DI		;
	PUSH	DX		;
	PUSH	CX		;
	PUSH	BX		;
	PUSH	AX		;
	PUSHF			;

	MOV	BGLIN,0		; Force a wipe from the top
	MOV	CL,DISLIN
	MOV	BGCNT0,CL	; Including the status line!

	MOV	ATRSAV,0C0H	; Reset the screen controls
	MOV	PRVATR,7	; Low intensity white
	MOV	CHARST,0	;

	CMP	SCRNMOD,0	; Is IRMAvision active?
	JNZ	UPDR1		; Yes - then all chars are displayed
;				; on the screen, so exit

	MOV	SI,BSADDR[2]	; Get address of line 1
	MOV	CX,TOPLIN	; Are there undisplayed characters?

UPDR0:	JCXZ	UPDR1		; Jump if we are done

	PUSH	CX		;
	CALL	READCH		; Get a character from the slave
	POP	CX		; Restore undamaged counter
	INC	SI		; Next buffer address
	DEC	CX		; One less character to check

	CMP	AL,0C0H		; The very first attribute
	JNAE	UPDR0		; Try for more attributes
	
	MOV	ATRSAV,AL	; Save the current attribute
	MOV	BL,1		; Anything except zero
	CALL	ATCALC		; Compute the next attribute
	MOV	PRVATR,CH	; Save the attribute
	MOV	CHARST,DH	; And the selected character set
	JMP	UPDR0		; And do another character

UPDR1:	POPF			; Restore the registers
	POP	AX		;
	POP	BX		;
	POP	CX		;
	POP	DX		;
	POP	DI		;
	POP	SI		;

	RET			;

UPDRST	ENDP
	PAGE
;
; UPDHBR - procedure to update horizontal bar above the status line.
;
; On entry: Nothing useful
;
; On exit: Nothing useful
; 
; Called by: ?
;
; Routines called: PUTCH
;
; Globals changed: None
;
; Globals accessed: SCRNMOD, COLROW
;
; History:
;   Date    Version   Prog.   Comments
; 1/22/85    1.40      jsc	Added changes for IRMAvision
;
	PUBLIC	UPDHBR		; Update horizontal bar
UPDHBR	PROC	NEAR		;
	MOV	BX,COLROW	; Number of characters on a line
	MOV	DI,((25-1)*80)*2 ; Address of horizontal bar land
	CMP	SCRNMOD,2	; Is this normal or IV Mod 2 display?
	JLE	UPDHB0		; Yes - jump
	MOV	DI,((33-1)*80)*2 ; No - assume IRMAvision Mod 3
	CMP	SCRNMOD,3	; Check it
	JE	UPDHB0		; Yes - jump
	MOV	DI,((44-1)*80)*2 ; No - assume IRMAvision Mod 4
	CMP	SCRNMOD,4	; Check it
	JE	UPDHB0		; Yes - jump
	MOV	DI,((28-1)*132)*2 ; Else assume IRMAvision Mod 5

UPDHB0:	MOV	CX,7C4H		; White horizontal bar
	CALL	PUTCH		; -

	DEC	BX		; One less to do
	JNZ	UPDHB0		;

	RET
UPDHBR	ENDP

CODE	ENDS

	END
