	NAME	RINGS
	INCLUDE	PAGESIZE.INC
	TITLE	.RINGS - Ring I/O routines
CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE

	PUBLIC	RINGIN
RINGIN	PROC	NEAR
	MOV	BX,[DI]		; Get input pointer
	MOV	CX,[DI]+2	;     output pointer
	MOV	DX,[DI]+4	;     size
	DEC	DX		; DX is pointer to last byte

	OR	CX,CX		; Is the output pointer at the bottom?
	JNZ	RIN0		; 

	CMP	BX,DX		; Is the input pointer at the top?
	JE	INFULL		; Yes, the ring is full on the edge.

RIN0:	DEC	CX		; Is input = output - 1 ?
	CMP	BX,CX		;
	JE	INFULL		; Yes, no room in the inn.

	MOV	[BX][DI]+6,AL	; Put the character into the ring

	INC	BX		; Bump the input pointer up one
	INC	DX		; DX points just past the end of the buffer
	CMP	BX,DX		; Are we just over?
	JNE	RIN1		; No, do not wrap the pointer

	XOR	BX,BX		; Wrap around to zero

RIN1:	MOV	[DI],BX		; Replace the input pointer
	STC			; Indicate success

	RET			;

INFULL:	OR	AL,AL		; Indicate failure, clear carry.
	RET			;

RINGIN	ENDP			;

	PAGE
	PUBLIC	RINGOUT
RINGOUT	PROC	NEAR

	MOV	BX,[DI]		; Get ring input pointer
	MOV	CX,[DI]+2	;          output pointer
	MOV	DX,[DI]+4	;          size

	CMP	BX,CX		; Is the ring empty?
	JE	EMPTY		; Yes, no luck this time

	MOV	BX,CX		; Get output pointer into base register
	MOV	AL,[DI][BX]+6	; Get byte out of ring

	INC	CX		; Move output pointer around
	CMP	CX,DX		; Is the output pointer just past the end?
	JNE	ROUT0		; No, do not wrap pointer

	XOR	CX,CX		; Wrap pointer to zero

ROUT0:	MOV	[DI]+2,CX	; Replace output pointer
	STC			; Indicate success
	RET			;

EMPTY:	OR	AL,AL		; Indicate failure with clear carry
	RET			;

RINGOUT	ENDP			;

	PAGE
	PUBLIC	RINGMT
RINGMT	PROC	NEAR

	MOV	BX,[DI]		;
	CMP	BX,[DI]+2	; Compare input and output pointer
	JZ	MT0		;

	STC			; Not empty
	RET			;

MT0:	XOR	BX,BX		; Zero, and carry clear
	RET			; Empty

RINGMT	ENDP

	PUBLIC	RINGROOM
RINGROOM PROC	NEAR

	MOV	BX,[DI]		; Input pointer
	MOV	CX,[DI+2]	; Output pointer
	MOV	DX,[DI+4]	; Max size

	CMP	BX,CX		;
	JG	ROOM0		;
	JE	ROOM1		; Empty

				; INPUT POINTER < OUTPUT POINTER
	SUB	CX,BX		; CX := Output-Input
	MOV	AX,CX		; AX := Available+1
	DEC	AX		; Return space in AX
	RET			;

				; INPUT POINTER > OUTPUT POINTER
ROOM0:	SUB	BX,CX		; BX := Input-output
	SUB	DX,BX		; DX := Maximum-Inuse
	MOV	AX,DX		; 
	DEC	AX		; AX := [Available+1]-1
	RET			;

				; INPUT POINTER = OUTPUT POINTER
ROOM1:	MOV	AX,DX		; Empty
	DEC	AX		;
	RET			;

RINGROOM ENDP

CODE	ENDS

	END
